// API C interface

#include <stdio.h>
#include <dos.h>
#include "api.h"
#include "apic.h"

unsigned api_int;
char id[] = "Inet";
WORD tcbs;

union REGS r;

int init_api(void)
{
	void interrupt (*int_apiv)();
	char far *pid;
	int i;

	for (api_int = 0x20;api_int < 0x100;++api_int) {
		int_apiv = getvect(api_int);
		if (int_apiv == 0)
			continue;
		pid = (char far *)int_apiv - 4;
		for (i = 0;i < 4;++i) {
			if (pid[i] != id[i])
				break;
		}
		if (i == 4)
			return api_int;
	}
	return -1;
}

DWORD resolve(char *name)
{
	WORD adr[2];
	r.x.cx = FP_OFF(name);
	r.x.bx = FP_SEG(name);
	r.h.ah = API_GETIPADR;
	int86(api_int,&r,&r);
	adr[1] = r.x.cx;
	adr[0] = r.x.dx;
	return *(DWORD *)adr;
}

char far *hostname(void)
{
	r.x.cx = r.x.bx = 0;
	r.h.ah = API_GETIPADR;
	int86(api_int,&r,&r);
	return MK_FP(r.x.bx,r.x.si);
}

WORD open_tcp(
struct socket *lsocket,	/* Local socket */
struct socket *fsocket,	/* Remote socket */
int mode,				/* Active/passive/server */
WORD window,			/* Receive window (and send buffer) sizes */
void (far *r_upcall)(/*WORD handle,WORD cnt*/),	/* Function to call when data arrives */
void (far *t_upcall)(),	/* Function to call when ok to send more data */
void (far *s_upcall)(/*WORD control,char old,char new*/),	/* Function to call when connection state changes */
char tos,
char *user)				/* User linkage area */
{
	TCP_OP_P op;

	if (fsocket) {
		op.rem_port = fsocket->port;
		op.rem_ip_ad = fsocket->address;
	}
	else {
		op.rem_port = 0;
		op.rem_ip_ad = 0;
	}
	op.loc_port = lsocket->port;
	op.mode = mode;		/* active/passive/server */
	op.window = window;	/* window size (0 for default) */
	op.rcv_upcall = r_upcall;
	op.snd_upcall = t_upcall;
	op.stc_upcall = s_upcall;
	op.user = user;	/* user id field in TCB */
	op.tos = tos;		/* type of service to use (normally 0) */
	r.x.cx = FP_OFF(&op);
	r.x.bx = FP_SEG(&op);
	r.h.ah = API_TCPOPEN;
	int86(api_int,&r,&r);
	lsocket->port = op.loc_port;
	tcbs = r.x.bx;
	if (r.x.cx == 0) {
		printf("TCP open error: %s\n",get_errstr(r.x.cx));
		return -r.x.ax;
	}
	return r.x.cx;
}

int send_tcp(WORD handle,char *buf,int len,BYTE flags)
{
	r.x.si = FP_OFF(buf);
	r.x.dx = FP_SEG(buf);
	r.x.cx = len;
	r.x.bx = handle;
	r.h.ah = API_TCPWRITE;
	r.h.al = flags;
	int86(api_int,&r,&r);
	if (r.x.ax != 0)
		return -r.x.ax;
	return r.x.cx;
}

int recv_tcp(WORD handle,char *buf,WORD cnt)
{
	r.x.si = FP_OFF(buf);
	r.x.dx = FP_SEG(buf);
	r.x.cx = cnt;
	r.x.bx = handle;
	r.h.ah = API_TCPREAD;
	int86(api_int,&r,&r);
	if (r.x.ax != 0)
		return -r.x.ax;
	return r.x.cx;
}

int close_tcp(WORD handle)
{
	r.x.bx = handle;
	r.h.ah = API_TCPCLOSE;
	int86(api_int,&r,&r);
	return -r.x.ax;
}

int reset_tcp(WORD handle)
{
	r.x.bx = handle;
	r.h.ah = API_TCPRESET;
	int86(api_int,&r,&r);
	return -r.x.ax;
}

int del_tcp(WORD handle)
{
	r.x.bx = handle;
	r.h.ah = API_TCPDELET;
	int86(api_int,&r,&r);
	return -r.x.ax;
}

TCB far *get_tcb(WORD handle)
{
	if (tcbs == 4)
		return (TCB far *)MK_FP(handle,4);
	else
		return (TCB far *)MK_FP(tcbs,handle);
}

char *get_errstr(WORD errcode)	/* return errorcode string */
{
	static char unk[30];
	static char *errs[] = {
		"No error",
		"Connection already exists",
		"Connection does not exist",
		"Connection closing",
		"No memory for TCB or buffer creation",
		"Would block",
		"Protocol or mode not supported",
		"Invalid arguments"
	};

	if (errcode > INVALID) {
		sprintf(unk,"Unknown error %u",errcode);
		return unk;
	}
	return errs[errcode];
}
